@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property addressCount Number of addresses in the range.
 * @property availableAddressCount Number of available addresses in the range.
 * @property firstAddress First address in the range.
 * @property lastAddress Last address in the range.
 */
public data class GetPublicIpv4PoolPoolAddressRange(
    public val addressCount: Int,
    public val availableAddressCount: Int,
    public val firstAddress: String,
    public val lastAddress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetPublicIpv4PoolPoolAddressRange):
            GetPublicIpv4PoolPoolAddressRange = GetPublicIpv4PoolPoolAddressRange(
            addressCount = javaType.addressCount(),
            availableAddressCount = javaType.availableAddressCount(),
            firstAddress = javaType.firstAddress(),
            lastAddress = javaType.lastAddress(),
        )
    }
}
