@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getPublicIpv4Pools.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property poolIds List of all the pool IDs found.
 * @property tags
 */
public data class GetPublicIpv4PoolsResult(
    public val filters: List<GetPublicIpv4PoolsFilter>? = null,
    public val id: String,
    public val poolIds: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetPublicIpv4PoolsResult):
            GetPublicIpv4PoolsResult = GetPublicIpv4PoolsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            poolIds = javaType.poolIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
