@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property gatewayId ID of an Internet Gateway or Virtual Private Gateway which is connected to the Route Table (not exported if not passed as a parameter).
 * @property main Whether the association is due to the main route table.
 * @property routeTableAssociationId Association ID.
 * @property routeTableId ID of the specific Route Table to retrieve.
 * @property subnetId ID of a Subnet which is connected to the Route Table (not exported if not passed as a parameter).
 */
public data class GetRouteTableAssociation(
    public val gatewayId: String,
    public val main: Boolean,
    public val routeTableAssociationId: String,
    public val routeTableId: String,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetRouteTableAssociation):
            GetRouteTableAssociation = GetRouteTableAssociation(
            gatewayId = javaType.gatewayId(),
            main = javaType.main(),
            routeTableAssociationId = javaType.routeTableAssociationId(),
            routeTableId = javaType.routeTableId(),
            subnetId = javaType.subnetId(),
        )
    }
}
