@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRouteTable.
 * @property arn ARN of the route table.
 * @property associations List of associations with attributes detailed below.
 * @property filters
 * @property gatewayId Gateway ID. Only set when associated with an Internet Gateway or Virtual Private Gateway.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ownerId ID of the AWS account that owns the route table.
 * @property routeTableId Route Table ID.
 * @property routes List of routes with attributes detailed below.
 * @property subnetId Subnet ID. Only set when associated with a subnet.
 * @property tags
 * @property vpcId
 */
public data class GetRouteTableResult(
    public val arn: String,
    public val associations: List<GetRouteTableAssociation>,
    public val filters: List<GetRouteTableFilter>? = null,
    public val gatewayId: String,
    public val id: String,
    public val ownerId: String,
    public val routeTableId: String,
    public val routes: List<GetRouteTableRoute>,
    public val subnetId: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetRouteTableResult):
            GetRouteTableResult = GetRouteTableResult(
            arn = javaType.arn(),
            associations = javaType.associations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableAssociation.Companion.toKotlin(args0)
                })
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableFilter.Companion.toKotlin(args0)
                })
            }),
            gatewayId = javaType.gatewayId(),
            id = javaType.id(),
            ownerId = javaType.ownerId(),
            routeTableId = javaType.routeTableId(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            subnetId = javaType.subnetId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
