@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property carrierGatewayId ID of the Carrier Gateway.
 * @property cidrBlock CIDR block of the route.
 * @property coreNetworkArn ARN of the core network.
 * @property destinationPrefixListId The ID of a managed prefix list destination of the route.
 * @property egressOnlyGatewayId ID of the Egress Only Internet Gateway.
 * @property gatewayId ID of an Internet Gateway or Virtual Private Gateway which is connected to the Route Table (not exported if not passed as a parameter).
 * @property instanceId EC2 instance ID.
 * @property ipv6CidrBlock IPv6 CIDR block of the route.
 * @property localGatewayId Local Gateway ID.
 * @property natGatewayId NAT Gateway ID.
 * @property networkInterfaceId ID of the elastic network interface (eni) to use.
 * @property transitGatewayId EC2 Transit Gateway ID.
 * @property vpcEndpointId VPC Endpoint ID.
 * @property vpcPeeringConnectionId VPC Peering ID.
 */
public data class GetRouteTableRoute(
    public val carrierGatewayId: String,
    public val cidrBlock: String,
    public val coreNetworkArn: String,
    public val destinationPrefixListId: String,
    public val egressOnlyGatewayId: String,
    public val gatewayId: String,
    public val instanceId: String,
    public val ipv6CidrBlock: String,
    public val localGatewayId: String,
    public val natGatewayId: String,
    public val networkInterfaceId: String,
    public val transitGatewayId: String,
    public val vpcEndpointId: String,
    public val vpcPeeringConnectionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetRouteTableRoute): GetRouteTableRoute =
            GetRouteTableRoute(
                carrierGatewayId = javaType.carrierGatewayId(),
                cidrBlock = javaType.cidrBlock(),
                coreNetworkArn = javaType.coreNetworkArn(),
                destinationPrefixListId = javaType.destinationPrefixListId(),
                egressOnlyGatewayId = javaType.egressOnlyGatewayId(),
                gatewayId = javaType.gatewayId(),
                instanceId = javaType.instanceId(),
                ipv6CidrBlock = javaType.ipv6CidrBlock(),
                localGatewayId = javaType.localGatewayId(),
                natGatewayId = javaType.natGatewayId(),
                networkInterfaceId = javaType.networkInterfaceId(),
                transitGatewayId = javaType.transitGatewayId(),
                vpcEndpointId = javaType.vpcEndpointId(),
                vpcPeeringConnectionId = javaType.vpcPeeringConnectionId(),
            )
    }
}
