@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecurityGroups.
 * @property arns ARNs of the matched security groups.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of the matches security groups.
 * @property tags
 * @property vpcIds VPC IDs of the matched security groups. The data source's tag or filter *will span VPCs* unless the `vpc-id` filter is also used.
 */
public data class GetSecurityGroupsResult(
    public val arns: List<String>,
    public val filters: List<GetSecurityGroupsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>,
    public val vpcIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetSecurityGroupsResult):
            GetSecurityGroupsResult = GetSecurityGroupsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcIds = javaType.vpcIds().map({ args0 -> args0 }),
        )
    }
}
