@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSpotPrice.
 * @property availabilityZone
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceType
 * @property spotPrice Most recent Spot Price value for the given instance type and AZ.
 * @property spotPriceTimestamp The timestamp at which the Spot Price value was published.
 */
public data class GetSpotPriceResult(
    public val availabilityZone: String? = null,
    public val filters: List<GetSpotPriceFilter>? = null,
    public val id: String,
    public val instanceType: String? = null,
    public val spotPrice: String,
    public val spotPriceTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetSpotPriceResult): GetSpotPriceResult =
            GetSpotPriceResult(
                availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetSpotPriceFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
                spotPrice = javaType.spotPrice(),
                spotPriceTimestamp = javaType.spotPriceTimestamp(),
            )
    }
}
