@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSubnet.
 * @property arn ARN of the subnet.
 * @property assignIpv6AddressOnCreation Whether an IPv6 address is assigned on creation.
 * @property availabilityZone
 * @property availabilityZoneId
 * @property availableIpAddressCount Available IP addresses of the subnet.
 * @property cidrBlock
 * @property customerOwnedIpv4Pool Identifier of customer owned IPv4 address pool.
 * @property defaultForAz
 * @property enableDns64 Whether DNS queries made to the Amazon-provided DNS Resolver in this subnet return synthetic IPv6 addresses for IPv4-only destinations.
 * @property enableLniAtDeviceIndex Indicates the device position for local network interfaces in this subnet. For example, 1 indicates local network interfaces in this subnet are the secondary network interface (eth1). A local network interface cannot be the primary network interface (eth0).
 * @property enableResourceNameDnsARecordOnLaunch Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
 * @property enableResourceNameDnsAaaaRecordOnLaunch Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
 * @property filters
 * @property id
 * @property ipv6CidrBlock
 * @property ipv6CidrBlockAssociationId Association ID of the IPv6 CIDR block.
 * @property ipv6Native Whether this is an IPv6-only subnet.
 * @property mapCustomerOwnedIpOnLaunch Whether customer owned IP addresses are assigned on network interface creation.
 * @property mapPublicIpOnLaunch Whether public IP addresses are assigned on instance launch.
 * @property outpostArn ARN of the Outpost.
 * @property ownerId ID of the AWS account that owns the subnet.
 * @property privateDnsHostnameTypeOnLaunch The type of hostnames assigned to instances in the subnet at launch.
 * @property state
 * @property tags
 * @property vpcId
 */
public data class GetSubnetResult(
    public val arn: String,
    public val assignIpv6AddressOnCreation: Boolean,
    public val availabilityZone: String,
    public val availabilityZoneId: String,
    public val availableIpAddressCount: Int,
    public val cidrBlock: String,
    public val customerOwnedIpv4Pool: String,
    public val defaultForAz: Boolean,
    public val enableDns64: Boolean,
    public val enableLniAtDeviceIndex: Int,
    public val enableResourceNameDnsARecordOnLaunch: Boolean,
    public val enableResourceNameDnsAaaaRecordOnLaunch: Boolean,
    public val filters: List<GetSubnetFilter>? = null,
    public val id: String,
    public val ipv6CidrBlock: String,
    public val ipv6CidrBlockAssociationId: String,
    public val ipv6Native: Boolean,
    public val mapCustomerOwnedIpOnLaunch: Boolean,
    public val mapPublicIpOnLaunch: Boolean,
    public val outpostArn: String,
    public val ownerId: String,
    public val privateDnsHostnameTypeOnLaunch: String,
    public val state: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetSubnetResult): GetSubnetResult =
            GetSubnetResult(
                arn = javaType.arn(),
                assignIpv6AddressOnCreation = javaType.assignIpv6AddressOnCreation(),
                availabilityZone = javaType.availabilityZone(),
                availabilityZoneId = javaType.availabilityZoneId(),
                availableIpAddressCount = javaType.availableIpAddressCount(),
                cidrBlock = javaType.cidrBlock(),
                customerOwnedIpv4Pool = javaType.customerOwnedIpv4Pool(),
                defaultForAz = javaType.defaultForAz(),
                enableDns64 = javaType.enableDns64(),
                enableLniAtDeviceIndex = javaType.enableLniAtDeviceIndex(),
                enableResourceNameDnsARecordOnLaunch = javaType.enableResourceNameDnsARecordOnLaunch(),
                enableResourceNameDnsAaaaRecordOnLaunch = javaType.enableResourceNameDnsAaaaRecordOnLaunch(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetSubnetFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ipv6CidrBlock = javaType.ipv6CidrBlock(),
                ipv6CidrBlockAssociationId = javaType.ipv6CidrBlockAssociationId(),
                ipv6Native = javaType.ipv6Native(),
                mapCustomerOwnedIpOnLaunch = javaType.mapCustomerOwnedIpOnLaunch(),
                mapPublicIpOnLaunch = javaType.mapPublicIpOnLaunch(),
                outpostArn = javaType.outpostArn(),
                ownerId = javaType.ownerId(),
                privateDnsHostnameTypeOnLaunch = javaType.privateDnsHostnameTypeOnLaunch(),
                state = javaType.state(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                vpcId = javaType.vpcId(),
            )
    }
}
