@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpcDhcpOptions.
 * @property arn ARN of the DHCP Options Set.
 * @property dhcpOptionsId EC2 DHCP Options ID
 * @property domainName Suffix domain name to used when resolving non Fully Qualified Domain NamesE.g., the `search` value in the `/etc/resolv.conf` file.
 * @property domainNameServers List of name servers.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property netbiosNameServers List of NETBIOS name servers.
 * @property netbiosNodeType NetBIOS node type (1, 2, 4, or 8). For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
 * @property ntpServers List of NTP servers.
 * @property ownerId ID of the AWS account that owns the DHCP options set.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetVpcDhcpOptionsResult(
    public val arn: String,
    public val dhcpOptionsId: String,
    public val domainName: String,
    public val domainNameServers: List<String>,
    public val filters: List<GetVpcDhcpOptionsFilter>? = null,
    public val id: String,
    public val netbiosNameServers: List<String>,
    public val netbiosNodeType: String,
    public val ntpServers: List<String>,
    public val ownerId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcDhcpOptionsResult):
            GetVpcDhcpOptionsResult = GetVpcDhcpOptionsResult(
            arn = javaType.arn(),
            dhcpOptionsId = javaType.dhcpOptionsId(),
            domainName = javaType.domainName(),
            domainNameServers = javaType.domainNameServers().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcDhcpOptionsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            netbiosNameServers = javaType.netbiosNameServers().map({ args0 -> args0 }),
            netbiosNodeType = javaType.netbiosNodeType(),
            ntpServers = javaType.ntpServers().map({ args0 -> args0 }),
            ownerId = javaType.ownerId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
