@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpcEndpointService.
 * @property acceptanceRequired Whether or not VPC endpoint connection requests to the service must be accepted by the service owner - `true` or `false`.
 * @property arn ARN of the VPC endpoint service.
 * @property availabilityZones Availability Zones in which the service is available.
 * @property baseEndpointDnsNames The DNS names for the service.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property managesVpcEndpoints Whether or not the service manages its VPC endpoints - `true` or `false`.
 * @property owner AWS account ID of the service owner or `amazon`.
 * @property privateDnsName Private DNS name for the service.
 * @property service
 * @property serviceId ID of the endpoint service.
 * @property serviceName
 * @property serviceType
 * @property supportedIpAddressTypes The supported IP address types.
 * @property tags Map of tags assigned to the resource.
 * @property vpcEndpointPolicySupported Whether or not the service supports endpoint policies - `true` or `false`.
 */
public data class GetVpcEndpointServiceResult(
    public val acceptanceRequired: Boolean,
    public val arn: String,
    public val availabilityZones: List<String>,
    public val baseEndpointDnsNames: List<String>,
    public val filters: List<GetVpcEndpointServiceFilter>? = null,
    public val id: String,
    public val managesVpcEndpoints: Boolean,
    public val owner: String,
    public val privateDnsName: String,
    public val service: String? = null,
    public val serviceId: String,
    public val serviceName: String,
    public val serviceType: String,
    public val supportedIpAddressTypes: List<String>,
    public val tags: Map<String, String>,
    public val vpcEndpointPolicySupported: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcEndpointServiceResult):
            GetVpcEndpointServiceResult = GetVpcEndpointServiceResult(
            acceptanceRequired = javaType.acceptanceRequired(),
            arn = javaType.arn(),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            baseEndpointDnsNames = javaType.baseEndpointDnsNames().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointServiceFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            managesVpcEndpoints = javaType.managesVpcEndpoints(),
            owner = javaType.owner(),
            privateDnsName = javaType.privateDnsName(),
            service = javaType.service().map({ args0 -> args0 }).orElse(null),
            serviceId = javaType.serviceId(),
            serviceName = javaType.serviceName(),
            serviceType = javaType.serviceType(),
            supportedIpAddressTypes = javaType.supportedIpAddressTypes().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcEndpointPolicySupported = javaType.vpcEndpointPolicySupported(),
        )
    }
}
