@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcIamPoolCidrs.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipamPoolCidrs The CIDRs provisioned into the IPAM pool, described below.
 * @property ipamPoolId
 */
public data class GetVpcIamPoolCidrsResult(
    public val filters: List<GetVpcIamPoolCidrsFilter>? = null,
    public val id: String,
    public val ipamPoolCidrs: List<GetVpcIamPoolCidrsIpamPoolCidr>,
    public val ipamPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcIamPoolCidrsResult):
            GetVpcIamPoolCidrsResult = GetVpcIamPoolCidrsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolCidrsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipamPoolCidrs = javaType.ipamPoolCidrs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolCidrsIpamPoolCidr.Companion.toKotlin(args0)
                })
            }),
            ipamPoolId = javaType.ipamPoolId(),
        )
    }
}
