@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcIamPools.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipamPools List of IPAM pools and their attributes. See below for details
 */
public data class GetVpcIamPoolsResult(
    public val filters: List<GetVpcIamPoolsFilter>? = null,
    public val id: String,
    public val ipamPools: List<GetVpcIamPoolsIpamPool>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcIamPoolsResult):
            GetVpcIamPoolsResult = GetVpcIamPoolsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipamPools = javaType.ipamPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolsIpamPool.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
