@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcIpamPoolCidrs.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipamPoolCidrs The CIDRs provisioned into the IPAM pool, described below.
 * @property ipamPoolId
 */
public data class GetVpcIpamPoolCidrsResult(
    public val filters: List<GetVpcIpamPoolCidrsFilter>? = null,
    public val id: String,
    public val ipamPoolCidrs: List<GetVpcIpamPoolCidrsIpamPoolCidr>,
    public val ipamPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcIpamPoolCidrsResult):
            GetVpcIpamPoolCidrsResult = GetVpcIpamPoolCidrsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolCidrsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipamPoolCidrs = javaType.ipamPoolCidrs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolCidrsIpamPoolCidr.Companion.toKotlin(args0)
                })
            }),
            ipamPoolId = javaType.ipamPoolId(),
        )
    }
}
