@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcIpamPools.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipamPools List of IPAM pools and their attributes. See below for details
 */
public data class GetVpcIpamPoolsResult(
    public val filters: List<GetVpcIpamPoolsFilter>? = null,
    public val id: String,
    public val ipamPools: List<GetVpcIpamPoolsIpamPool>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpcIpamPoolsResult):
            GetVpcIpamPoolsResult = GetVpcIpamPoolsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipamPools = javaType.ipamPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolsIpamPool.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
