@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpnGateway.
 * @property amazonSideAsn
 * @property arn
 * @property attachedVpcId
 * @property availabilityZone
 * @property filters
 * @property id
 * @property state
 * @property tags
 */
public data class GetVpnGatewayResult(
    public val amazonSideAsn: String,
    public val arn: String,
    public val attachedVpcId: String,
    public val availabilityZone: String,
    public val filters: List<GetVpnGatewayFilter>? = null,
    public val id: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetVpnGatewayResult):
            GetVpnGatewayResult = GetVpnGatewayResult(
            amazonSideAsn = javaType.amazonSideAsn(),
            arn = javaType.arn(),
            attachedVpcId = javaType.attachedVpcId(),
            availabilityZone = javaType.availabilityZone(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetVpnGatewayFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
