@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
 * @property capacityReservationTarget Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
 * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
 */
public data class InstanceCapacityReservationSpecification(
    public val capacityReservationPreference: String? = null,
    public val capacityReservationTarget:
    InstanceCapacityReservationSpecificationCapacityReservationTarget? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceCapacityReservationSpecification):
            InstanceCapacityReservationSpecification = InstanceCapacityReservationSpecification(
            capacityReservationPreference = javaType.capacityReservationPreference().map({ args0 ->
                args0
            }).orElse(null),
            capacityReservationTarget = javaType.capacityReservationTarget().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.InstanceCapacityReservationSpecificationCapacityReservationTarget.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
