@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuCredits Credit option for CPU usage. Valid values include `standard` or `unlimited`. T3 instances are launched as unlimited by default. T2 instances are launched as standard by default.
 */
public data class InstanceCreditSpecification(
    public val cpuCredits: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceCreditSpecification):
            InstanceCreditSpecification = InstanceCreditSpecification(
            cpuCredits = javaType.cpuCredits().map({ args0 -> args0 }).orElse(null),
        )
    }
}
