@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property deleteOnTermination Whether the volume should be destroyed on instance termination. Defaults to `true`.
 * @property deviceName Name of the device to mount.
 * @property encrypted Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume. Defaults to `false`. Cannot be used with `snapshot_id`. Must be configured to perform drift detection.
 * @property iops Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
 * @property kmsKeyId Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
 * @property snapshotId Snapshot ID to mount.
 * @property tags Map of tags to assign to the device.
 * @property throughput Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
 * @property volumeId ID of the volume. For example, the ID can be accessed like this, `aws_instance.web.root_block_device.0.volume_id`.
 * @property volumeSize Size of the volume in gibibytes (GiB).
 * @property volumeType Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to `gp2`.
 * > **NOTE:** Currently, changes to the `ebs_block_device` configuration of _existing_ resources cannot be automatically detected by this provider. To manage changes and attachments of an EBS block to an instance, use the `aws.ebs.Volume` and `aws.ec2.VolumeAttachment` resources instead. If you use `ebs_block_device` on an `aws.ec2.Instance`, this provider will assume management over the full set of non-root EBS block devices for the instance, treating additional block devices as drift. For this reason, `ebs_block_device` cannot be mixed with external `aws.ebs.Volume` and `aws.ec2.VolumeAttachment` resources for a given instance.
 */
public data class InstanceEbsBlockDevice(
    public val deleteOnTermination: Boolean? = null,
    public val deviceName: String,
    public val encrypted: Boolean? = null,
    public val iops: Int? = null,
    public val kmsKeyId: String? = null,
    public val snapshotId: String? = null,
    public val tags: Map<String, String>? = null,
    public val throughput: Int? = null,
    public val volumeId: String? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceEbsBlockDevice):
            InstanceEbsBlockDevice = InstanceEbsBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            deviceName = javaType.deviceName(),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeId = javaType.volumeId().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
