@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property marketType Type of market for the instance. Valid value is `spot`. Defaults to `spot`.
 * @property spotOptions Block to configure the options for Spot Instances. See Spot Options below for details on attributes.
 */
public data class InstanceInstanceMarketOptions(
    public val marketType: String? = null,
    public val spotOptions: InstanceInstanceMarketOptionsSpotOptions? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceInstanceMarketOptions):
            InstanceInstanceMarketOptions = InstanceInstanceMarketOptions(
            marketType = javaType.marketType().map({ args0 -> args0 }).orElse(null),
            spotOptions = javaType.spotOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.InstanceInstanceMarketOptionsSpotOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
