@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id ID of the launch template. Conflicts with `name`.
 * @property name Name of the launch template. Conflicts with `id`.
 * @property version Template version. Can be a specific version number, `$Latest` or `$Default`. The default value is `$Default`.
 */
public data class InstanceLaunchTemplate(
    public val id: String? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceLaunchTemplate):
            InstanceLaunchTemplate = InstanceLaunchTemplate(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
