@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoRecovery Automatic recovery behavior of the Instance. Can be `"default"` or `"disabled"`. See [Recover your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html) for more details.
 */
public data class InstanceMaintenanceOptions(
    public val autoRecovery: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.InstanceMaintenanceOptions):
            InstanceMaintenanceOptions = InstanceMaintenanceOptions(
            autoRecovery = javaType.autoRecovery().map({ args0 -> args0 }).orElse(null),
        )
    }
}
