@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination
 * @property encrypted
 * @property iops
 * @property throughput
 * @property volumeSize
 * @property volumeType
 */
public data class LaunchConfigurationRootBlockDevice(
    public val deleteOnTermination: Boolean? = null,
    public val encrypted: Boolean? = null,
    public val iops: Int? = null,
    public val throughput: Int? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchConfigurationRootBlockDevice):
            LaunchConfigurationRootBlockDevice = LaunchConfigurationRootBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
