@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Whether the volume should be destroyed on instance termination.
 * See [Preserving Amazon EBS Volumes on Instance Termination](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination) for more information.
 * @property encrypted Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
 * Cannot be used with `snapshot_id`.
 * @property iops The amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html).
 * This must be set with a `volume_type` of `"io1/io2/gp3"`.
 * @property kmsKeyId The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted volume.
 * `encrypted` must be set to `true` when this is set.
 * @property snapshotId The Snapshot ID to mount.
 * @property throughput The throughput to provision for a `gp3` volume in MiB/s (specified as an integer, e.g., 500), with a maximum of 1,000 MiB/s.
 * @property volumeSize The size of the volume in gigabytes.
 * @property volumeType The volume type.
 * Can be one of `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1`.
 */
public data class LaunchTemplateBlockDeviceMappingEbs(
    public val deleteOnTermination: String? = null,
    public val encrypted: String? = null,
    public val iops: Int? = null,
    public val kmsKeyId: String? = null,
    public val snapshotId: String? = null,
    public val throughput: Int? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateBlockDeviceMappingEbs):
            LaunchTemplateBlockDeviceMappingEbs = LaunchTemplateBlockDeviceMappingEbs(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
