@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuCredits The credit option for CPU usage.
 * Can be `standard` or `unlimited`.
 * T3 instances are launched as `unlimited` by default.
 * T2 instances are launched as `standard` by default.
 */
public data class LaunchTemplateCreditSpecification(
    public val cpuCredits: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateCreditSpecification):
            LaunchTemplateCreditSpecification = LaunchTemplateCreditSpecification(
            cpuCredits = javaType.cpuCredits().map({ args0 -> args0 }).orElse(null),
        )
    }
}
