@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property blockDurationMinutes The required duration in minutes. This value must be a multiple of 60.
 * @property instanceInterruptionBehavior The behavior when a Spot Instance is interrupted. Can be `hibernate`,
 * `stop`, or `terminate`. (Default: `terminate`).
 * @property maxPrice The maximum hourly price you're willing to pay for the Spot Instances.
 * @property spotInstanceType The Spot Instance request type. Can be `one-time`, or `persistent`.
 * @property validUntil The end date of the request.
 */
public data class LaunchTemplateInstanceMarketOptionsSpotOptions(
    public val blockDurationMinutes: Int? = null,
    public val instanceInterruptionBehavior: String? = null,
    public val maxPrice: String? = null,
    public val spotInstanceType: String? = null,
    public val validUntil: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateInstanceMarketOptionsSpotOptions):
            LaunchTemplateInstanceMarketOptionsSpotOptions =
            LaunchTemplateInstanceMarketOptionsSpotOptions(
                blockDurationMinutes = javaType.blockDurationMinutes().map({ args0 -> args0 }).orElse(null),
                instanceInterruptionBehavior = javaType.instanceInterruptionBehavior().map({ args0 ->
                    args0
                }).orElse(null),
                maxPrice = javaType.maxPrice().map({ args0 -> args0 }).orElse(null),
                spotInstanceType = javaType.spotInstanceType().map({ args0 -> args0 }).orElse(null),
                validUntil = javaType.validUntil().map({ args0 -> args0 }).orElse(null),
            )
    }
}
