@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoRecovery Disables the automatic recovery behavior of your instance or sets it to default. Can be `"default"` or `"disabled"`. See [Recover your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html) for more details.
 */
public data class LaunchTemplateMaintenanceOptions(
    public val autoRecovery: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateMaintenanceOptions):
            LaunchTemplateMaintenanceOptions = LaunchTemplateMaintenanceOptions(
            autoRecovery = javaType.autoRecovery().map({ args0 -> args0 }).orElse(null),
        )
    }
}
