@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpEndpoint Whether the metadata service is available. Can be `"enabled"` or `"disabled"`. (Default: `"enabled"`).
 * @property httpProtocolIpv6 Enables or disables the IPv6 endpoint for the instance metadata service. Can be `"enabled"` or `"disabled"`.
 * @property httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`. (Default: `1`).
 * @property httpTokens Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"` or `"required"`. (Default: `"optional"`).
 * @property instanceMetadataTags Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"` or `"disabled"`.
 * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
 */
public data class LaunchTemplateMetadataOptions(
    public val httpEndpoint: String? = null,
    public val httpProtocolIpv6: String? = null,
    public val httpPutResponseHopLimit: Int? = null,
    public val httpTokens: String? = null,
    public val instanceMetadataTags: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplateMetadataOptions):
            LaunchTemplateMetadataOptions = LaunchTemplateMetadataOptions(
            httpEndpoint = javaType.httpEndpoint().map({ args0 -> args0 }).orElse(null),
            httpProtocolIpv6 = javaType.httpProtocolIpv6().map({ args0 -> args0 }).orElse(null),
            httpPutResponseHopLimit = javaType.httpPutResponseHopLimit().map({ args0 -> args0 }).orElse(null),
            httpTokens = javaType.httpTokens().map({ args0 -> args0 }).orElse(null),
            instanceMetadataTags = javaType.instanceMetadataTags().map({ args0 -> args0 }).orElse(null),
        )
    }
}
