@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
 * @property enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
 * @property hostnameType The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name` and `resource-name`.
 */
public data class LaunchTemplatePrivateDnsNameOptions(
    public val enableResourceNameDnsARecord: Boolean? = null,
    public val enableResourceNameDnsAaaaRecord: Boolean? = null,
    public val hostnameType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.LaunchTemplatePrivateDnsNameOptions):
            LaunchTemplatePrivateDnsNameOptions = LaunchTemplatePrivateDnsNameOptions(
            enableResourceNameDnsARecord = javaType.enableResourceNameDnsARecord().map({ args0 ->
                args0
            }).orElse(null),
            enableResourceNameDnsAaaaRecord = javaType.enableResourceNameDnsAaaaRecord().map({ args0 ->
                args0
            }).orElse(null),
            hostnameType = javaType.hostnameType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
