@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclRules
 * @property acls
 * @property address
 * @property addresses
 * @property attachedTos
 * @property availabilityZones
 * @property cidrs
 * @property classicLoadBalancerListeners
 * @property components
 * @property customerGateways
 * @property destinationVpcs
 * @property destinations
 * @property direction
 * @property elasticLoadBalancerListeners
 * @property explanationCode
 * @property ingressRouteTables
 * @property internetGateways
 * @property loadBalancerArn
 * @property loadBalancerListenerPort
 * @property loadBalancerTargetGroup
 * @property loadBalancerTargetGroups
 * @property loadBalancerTargetPort
 * @property missingComponent
 * @property natGateways
 * @property networkInterfaces
 * @property packetField
 * @property port
 * @property portRanges
 * @property prefixLists
 * @property protocols
 * @property routeTableRoutes
 * @property routeTables
 * @property securityGroup
 * @property securityGroupRules
 * @property securityGroups
 * @property sourceVpcs
 * @property state
 * @property subnetRouteTables
 * @property subnets
 * @property transitGatewayAttachments
 * @property transitGatewayRouteTableRoutes
 * @property transitGatewayRouteTables
 * @property transitGateways
 * @property vpcEndpoints
 * @property vpcPeeringConnections
 * @property vpcs
 * @property vpnConnections
 * @property vpnGateways
 */
public data class NetworkInsightsAnalysisExplanation(
    public val aclRules: List<NetworkInsightsAnalysisExplanationAclRule>? = null,
    public val acls: List<NetworkInsightsAnalysisExplanationAcl>? = null,
    public val address: String? = null,
    public val addresses: List<String>? = null,
    public val attachedTos: List<NetworkInsightsAnalysisExplanationAttachedTo>? = null,
    public val availabilityZones: List<String>? = null,
    public val cidrs: List<String>? = null,
    public val classicLoadBalancerListeners:
    List<NetworkInsightsAnalysisExplanationClassicLoadBalancerListener>? = null,
    public val components: List<NetworkInsightsAnalysisExplanationComponent>? = null,
    public val customerGateways: List<NetworkInsightsAnalysisExplanationCustomerGateway>? = null,
    public val destinationVpcs: List<NetworkInsightsAnalysisExplanationDestinationVpc>? = null,
    public val destinations: List<NetworkInsightsAnalysisExplanationDestination>? = null,
    public val direction: String? = null,
    public val elasticLoadBalancerListeners:
    List<NetworkInsightsAnalysisExplanationElasticLoadBalancerListener>? = null,
    public val explanationCode: String? = null,
    public val ingressRouteTables: List<NetworkInsightsAnalysisExplanationIngressRouteTable>? = null,
    public val internetGateways: List<NetworkInsightsAnalysisExplanationInternetGateway>? = null,
    public val loadBalancerArn: String? = null,
    public val loadBalancerListenerPort: Int? = null,
    public val loadBalancerTargetGroup:
    List<NetworkInsightsAnalysisExplanationLoadBalancerTargetGroup>? = null,
    public val loadBalancerTargetGroups:
    List<NetworkInsightsAnalysisExplanationLoadBalancerTargetGroup>? = null,
    public val loadBalancerTargetPort: Int? = null,
    public val missingComponent: String? = null,
    public val natGateways: List<NetworkInsightsAnalysisExplanationNatGateway>? = null,
    public val networkInterfaces: List<NetworkInsightsAnalysisExplanationNetworkInterface>? = null,
    public val packetField: String? = null,
    public val port: Int? = null,
    public val portRanges: List<NetworkInsightsAnalysisExplanationPortRange>? = null,
    public val prefixLists: List<NetworkInsightsAnalysisExplanationPrefixList>? = null,
    public val protocols: List<String>? = null,
    public val routeTableRoutes: List<NetworkInsightsAnalysisExplanationRouteTableRoute>? = null,
    public val routeTables: List<NetworkInsightsAnalysisExplanationRouteTable>? = null,
    public val securityGroup: List<NetworkInsightsAnalysisExplanationSecurityGroup>? = null,
    public val securityGroupRules: List<NetworkInsightsAnalysisExplanationSecurityGroupRule>? = null,
    public val securityGroups: List<NetworkInsightsAnalysisExplanationSecurityGroup>? = null,
    public val sourceVpcs: List<NetworkInsightsAnalysisExplanationSourceVpc>? = null,
    public val state: String? = null,
    public val subnetRouteTables: List<NetworkInsightsAnalysisExplanationSubnetRouteTable>? = null,
    public val subnets: List<NetworkInsightsAnalysisExplanationSubnet>? = null,
    public val transitGatewayAttachments:
    List<NetworkInsightsAnalysisExplanationTransitGatewayAttachment>? = null,
    public val transitGatewayRouteTableRoutes:
    List<NetworkInsightsAnalysisExplanationTransitGatewayRouteTableRoute>? = null,
    public val transitGatewayRouteTables:
    List<NetworkInsightsAnalysisExplanationTransitGatewayRouteTable>? = null,
    public val transitGateways: List<NetworkInsightsAnalysisExplanationTransitGateway>? = null,
    public val vpcEndpoints: List<NetworkInsightsAnalysisExplanationVpcEndpoint>? = null,
    public val vpcPeeringConnections: List<NetworkInsightsAnalysisExplanationVpcPeeringConnection>? =
        null,
    public val vpcs: List<NetworkInsightsAnalysisExplanationVpc>? = null,
    public val vpnConnections: List<NetworkInsightsAnalysisExplanationVpnConnection>? = null,
    public val vpnGateways: List<NetworkInsightsAnalysisExplanationVpnGateway>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInsightsAnalysisExplanation):
            NetworkInsightsAnalysisExplanation = NetworkInsightsAnalysisExplanation(
            aclRules = javaType.aclRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationAclRule.Companion.toKotlin(args0)
                })
            }),
            acls = javaType.acls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationAcl.Companion.toKotlin(args0)
                })
            }),
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            addresses = javaType.addresses().map({ args0 -> args0 }),
            attachedTos = javaType.attachedTos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationAttachedTo.Companion.toKotlin(args0)
                })
            }),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            cidrs = javaType.cidrs().map({ args0 -> args0 }),
            classicLoadBalancerListeners = javaType.classicLoadBalancerListeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationClassicLoadBalancerListener.Companion.toKotlin(args0)
                })
            }),
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationComponent.Companion.toKotlin(args0)
                })
            }),
            customerGateways = javaType.customerGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationCustomerGateway.Companion.toKotlin(args0)
                })
            }),
            destinationVpcs = javaType.destinationVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationDestinationVpc.Companion.toKotlin(args0)
                })
            }),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationDestination.Companion.toKotlin(args0)
                })
            }),
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            elasticLoadBalancerListeners = javaType.elasticLoadBalancerListeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationElasticLoadBalancerListener.Companion.toKotlin(args0)
                })
            }),
            explanationCode = javaType.explanationCode().map({ args0 -> args0 }).orElse(null),
            ingressRouteTables = javaType.ingressRouteTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationIngressRouteTable.Companion.toKotlin(args0)
                })
            }),
            internetGateways = javaType.internetGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationInternetGateway.Companion.toKotlin(args0)
                })
            }),
            loadBalancerArn = javaType.loadBalancerArn().map({ args0 -> args0 }).orElse(null),
            loadBalancerListenerPort = javaType.loadBalancerListenerPort().map({ args0 -> args0 }).orElse(null),
            loadBalancerTargetGroup = javaType.loadBalancerTargetGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationLoadBalancerTargetGroup.Companion.toKotlin(args0)
                })
            }),
            loadBalancerTargetGroups = javaType.loadBalancerTargetGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationLoadBalancerTargetGroup.Companion.toKotlin(args0)
                })
            }),
            loadBalancerTargetPort = javaType.loadBalancerTargetPort().map({ args0 -> args0 }).orElse(null),
            missingComponent = javaType.missingComponent().map({ args0 -> args0 }).orElse(null),
            natGateways = javaType.natGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationNatGateway.Companion.toKotlin(args0)
                })
            }),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationNetworkInterface.Companion.toKotlin(args0)
                })
            }),
            packetField = javaType.packetField().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            portRanges = javaType.portRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationPortRange.Companion.toKotlin(args0)
                })
            }),
            prefixLists = javaType.prefixLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationPrefixList.Companion.toKotlin(args0)
                })
            }),
            protocols = javaType.protocols().map({ args0 -> args0 }),
            routeTableRoutes = javaType.routeTableRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            routeTables = javaType.routeTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationRouteTable.Companion.toKotlin(args0)
                })
            }),
            securityGroup = javaType.securityGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSecurityGroup.Companion.toKotlin(args0)
                })
            }),
            securityGroupRules = javaType.securityGroupRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSecurityGroupRule.Companion.toKotlin(args0)
                })
            }),
            securityGroups = javaType.securityGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSecurityGroup.Companion.toKotlin(args0)
                })
            }),
            sourceVpcs = javaType.sourceVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSourceVpc.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            subnetRouteTables = javaType.subnetRouteTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSubnetRouteTable.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationSubnet.Companion.toKotlin(args0)
                })
            }),
            transitGatewayAttachments = javaType.transitGatewayAttachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationTransitGatewayAttachment.Companion.toKotlin(args0)
                })
            }),
            transitGatewayRouteTableRoutes = javaType.transitGatewayRouteTableRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationTransitGatewayRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            transitGatewayRouteTables = javaType.transitGatewayRouteTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationTransitGatewayRouteTable.Companion.toKotlin(args0)
                })
            }),
            transitGateways = javaType.transitGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationTransitGateway.Companion.toKotlin(args0)
                })
            }),
            vpcEndpoints = javaType.vpcEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationVpcEndpoint.Companion.toKotlin(args0)
                })
            }),
            vpcPeeringConnections = javaType.vpcPeeringConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationVpcPeeringConnection.Companion.toKotlin(args0)
                })
            }),
            vpcs = javaType.vpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationVpc.Companion.toKotlin(args0)
                })
            }),
            vpnConnections = javaType.vpnConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationVpnConnection.Companion.toKotlin(args0)
                })
            }),
            vpnGateways = javaType.vpnGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationVpnGateway.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
