@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidr
 * @property egress
 * @property portRanges
 * @property protocol
 * @property ruleAction
 * @property ruleNumber
 */
public data class NetworkInsightsAnalysisExplanationAclRule(
    public val cidr: String? = null,
    public val egress: Boolean? = null,
    public val portRanges: List<NetworkInsightsAnalysisExplanationAclRulePortRange>? = null,
    public val protocol: String? = null,
    public val ruleAction: String? = null,
    public val ruleNumber: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInsightsAnalysisExplanationAclRule):
            NetworkInsightsAnalysisExplanationAclRule = NetworkInsightsAnalysisExplanationAclRule(
            cidr = javaType.cidr().map({ args0 -> args0 }).orElse(null),
            egress = javaType.egress().map({ args0 -> args0 }).orElse(null),
            portRanges = javaType.portRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisExplanationAclRulePortRange.Companion.toKotlin(args0)
                })
            }),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            ruleAction = javaType.ruleAction().map({ args0 -> args0 }).orElse(null),
            ruleNumber = javaType.ruleNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
