@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclRules
 * @property additionalDetails
 * @property attachedTos
 * @property components
 * @property destinationVpcs
 * @property inboundHeaders
 * @property outboundHeaders
 * @property routeTableRoutes
 * @property securityGroupRules
 * @property sequenceNumber
 * @property sourceVpcs
 * @property subnets
 * @property transitGatewayRouteTableRoutes
 * @property transitGateways
 * @property vpcs
 */
public data class NetworkInsightsAnalysisForwardPathComponent(
    public val aclRules: List<NetworkInsightsAnalysisForwardPathComponentAclRule>? = null,
    public val additionalDetails: List<NetworkInsightsAnalysisForwardPathComponentAdditionalDetail>? =
        null,
    public val attachedTos: List<NetworkInsightsAnalysisForwardPathComponentAttachedTo>? = null,
    public val components: List<NetworkInsightsAnalysisForwardPathComponentComponent>? = null,
    public val destinationVpcs: List<NetworkInsightsAnalysisForwardPathComponentDestinationVpc>? =
        null,
    public val inboundHeaders: List<NetworkInsightsAnalysisForwardPathComponentInboundHeader>? = null,
    public val outboundHeaders: List<NetworkInsightsAnalysisForwardPathComponentOutboundHeader>? =
        null,
    public val routeTableRoutes: List<NetworkInsightsAnalysisForwardPathComponentRouteTableRoute>? =
        null,
    public val securityGroupRules: List<NetworkInsightsAnalysisForwardPathComponentSecurityGroupRule>? =
        null,
    public val sequenceNumber: Int? = null,
    public val sourceVpcs: List<NetworkInsightsAnalysisForwardPathComponentSourceVpc>? = null,
    public val subnets: List<NetworkInsightsAnalysisForwardPathComponentSubnet>? = null,
    public val transitGatewayRouteTableRoutes:
    List<NetworkInsightsAnalysisForwardPathComponentTransitGatewayRouteTableRoute>? = null,
    public val transitGateways: List<NetworkInsightsAnalysisForwardPathComponentTransitGateway>? =
        null,
    public val vpcs: List<NetworkInsightsAnalysisForwardPathComponentVpc>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInsightsAnalysisForwardPathComponent):
            NetworkInsightsAnalysisForwardPathComponent = NetworkInsightsAnalysisForwardPathComponent(
            aclRules = javaType.aclRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentAclRule.Companion.toKotlin(args0)
                })
            }),
            additionalDetails = javaType.additionalDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentAdditionalDetail.Companion.toKotlin(args0)
                })
            }),
            attachedTos = javaType.attachedTos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentAttachedTo.Companion.toKotlin(args0)
                })
            }),
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentComponent.Companion.toKotlin(args0)
                })
            }),
            destinationVpcs = javaType.destinationVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentDestinationVpc.Companion.toKotlin(args0)
                })
            }),
            inboundHeaders = javaType.inboundHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentInboundHeader.Companion.toKotlin(args0)
                })
            }),
            outboundHeaders = javaType.outboundHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentOutboundHeader.Companion.toKotlin(args0)
                })
            }),
            routeTableRoutes = javaType.routeTableRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            securityGroupRules = javaType.securityGroupRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentSecurityGroupRule.Companion.toKotlin(args0)
                })
            }),
            sequenceNumber = javaType.sequenceNumber().map({ args0 -> args0 }).orElse(null),
            sourceVpcs = javaType.sourceVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentSourceVpc.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentSubnet.Companion.toKotlin(args0)
                })
            }),
            transitGatewayRouteTableRoutes = javaType.transitGatewayRouteTableRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentTransitGatewayRouteTableRoute.Companion.toKotlin(args0)
                })
            }),
            transitGateways = javaType.transitGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentTransitGateway.Companion.toKotlin(args0)
                })
            }),
            vpcs = javaType.vpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.NetworkInsightsAnalysisForwardPathComponentVpc.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
