@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attachmentId
 * @property deviceIndex Integer to define the devices index.
 * @property instance ID of the instance to attach to.
 */
public data class NetworkInterfaceAttachment(
    public val attachmentId: String? = null,
    public val deviceIndex: Int,
    public val instance: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.NetworkInterfaceAttachment):
            NetworkInterfaceAttachment = NetworkInterfaceAttachment(
            attachmentId = javaType.attachmentId().map({ args0 -> args0 }).orElse(null),
            deviceIndex = javaType.deviceIndex(),
            instance = javaType.instance(),
        )
    }
}
