@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidrBlocks List of CIDR blocks.
 * @property description Description of this ingress rule.
 * @property fromPort Start port (or ICMP type number if protocol is `icmp` or `icmpv6`).
 * @property ipv6CidrBlocks List of IPv6 CIDR blocks.
 * @property prefixListIds List of Prefix List IDs.
 * @property protocol Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0.  The supported values are defined in the `IpProtocol` argument on the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
 * The following arguments are optional:
 * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
 * @property securityGroups List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
 * @property self Whether the security group itself will be added as a source to this ingress rule.
 * @property toPort End range port (or ICMP code if protocol is `icmp`).
 */
public data class SecurityGroupIngress(
    public val cidrBlocks: List<String>? = null,
    public val description: String? = null,
    public val fromPort: Int,
    public val ipv6CidrBlocks: List<String>? = null,
    public val prefixListIds: List<String>? = null,
    public val protocol: String,
    public val securityGroups: List<String>? = null,
    public val self: Boolean? = null,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SecurityGroupIngress):
            SecurityGroupIngress = SecurityGroupIngress(
            cidrBlocks = javaType.cidrBlocks().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fromPort = javaType.fromPort(),
            ipv6CidrBlocks = javaType.ipv6CidrBlocks().map({ args0 -> args0 }),
            prefixListIds = javaType.prefixListIds().map({ args0 -> args0 }),
            protocol = javaType.protocol(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            self = javaType.self().map({ args0 -> args0 }).orElse(null),
            toPort = javaType.toPort(),
        )
    }
}
