@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property ami
 * @property associatePublicIpAddress
 * @property availabilityZone The availability zone in which to place the request.
 * @property ebsBlockDevices
 * @property ebsOptimized
 * @property ephemeralBlockDevices
 * @property iamInstanceProfile
 * @property iamInstanceProfileArn
 * @property instanceType The type of instance to request.
 * @property keyName
 * @property monitoring
 * @property placementGroup
 * @property placementTenancy
 * @property rootBlockDevices
 * @property spotPrice The maximum bid price per unit hour.
 * @property subnetId The subnet in which to launch the requested instance.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userData
 * @property vpcSecurityGroupIds
 * @property weightedCapacity The capacity added to the fleet by a fulfilled request.
 */
public data class SpotFleetRequestLaunchSpecification(
    public val ami: String,
    public val associatePublicIpAddress: Boolean? = null,
    public val availabilityZone: String? = null,
    public val ebsBlockDevices: List<SpotFleetRequestLaunchSpecificationEbsBlockDevice>? = null,
    public val ebsOptimized: Boolean? = null,
    public val ephemeralBlockDevices: List<SpotFleetRequestLaunchSpecificationEphemeralBlockDevice>? =
        null,
    public val iamInstanceProfile: String? = null,
    public val iamInstanceProfileArn: String? = null,
    public val instanceType: String,
    public val keyName: String? = null,
    public val monitoring: Boolean? = null,
    public val placementGroup: String? = null,
    public val placementTenancy: String? = null,
    public val rootBlockDevices: List<SpotFleetRequestLaunchSpecificationRootBlockDevice>? = null,
    public val spotPrice: String? = null,
    public val subnetId: String? = null,
    public val tags: Map<String, String>? = null,
    public val userData: String? = null,
    public val vpcSecurityGroupIds: List<String>? = null,
    public val weightedCapacity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotFleetRequestLaunchSpecification):
            SpotFleetRequestLaunchSpecification = SpotFleetRequestLaunchSpecification(
            ami = javaType.ami(),
            associatePublicIpAddress = javaType.associatePublicIpAddress().map({ args0 -> args0 }).orElse(null),
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            ebsBlockDevices = javaType.ebsBlockDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchSpecificationEbsBlockDevice.Companion.toKotlin(args0)
                })
            }),
            ebsOptimized = javaType.ebsOptimized().map({ args0 -> args0 }).orElse(null),
            ephemeralBlockDevices = javaType.ephemeralBlockDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchSpecificationEphemeralBlockDevice.Companion.toKotlin(args0)
                })
            }),
            iamInstanceProfile = javaType.iamInstanceProfile().map({ args0 -> args0 }).orElse(null),
            iamInstanceProfileArn = javaType.iamInstanceProfileArn().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            monitoring = javaType.monitoring().map({ args0 -> args0 }).orElse(null),
            placementGroup = javaType.placementGroup().map({ args0 -> args0 }).orElse(null),
            placementTenancy = javaType.placementTenancy().map({ args0 -> args0 }).orElse(null),
            rootBlockDevices = javaType.rootBlockDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchSpecificationRootBlockDevice.Companion.toKotlin(args0)
                })
            }),
            spotPrice = javaType.spotPrice().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userData = javaType.userData().map({ args0 -> args0 }).orElse(null),
            vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
