@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the launch template. Conflicts with `name`.
 * @property name The name of the launch template. Conflicts with `id`.
 * @property version Template version. Unlike the autoscaling equivalent, does not support `$Latest` or `$Default`, so use the launch_template resource's attribute, e.g., `"${aws_launch_template.foo.latest_version}"`. It will use the default version if omitted.
 * **Note:** The specified launch template can specify only a subset of the
 * inputs of `aws.ec2.LaunchTemplate`.  There are limitations on
 * what you can specify as spot fleet does not support all the attributes that are supported by autoscaling groups. [AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#launch-templates-spot-fleet) is currently sparse, but at least `instance_initiated_shutdown_behavior` is confirmed unsupported.
 */
public data class SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification(
    public val id: String? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification):
            SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification =
            SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecification(
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
            )
    }
}
