@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone The availability zone in which to place the request.
 * @property instanceRequirements The instance requirements. See below.
 * @property instanceType The type of instance to request.
 * @property priority The priority for the launch template override. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority.
 * @property spotPrice The maximum spot bid for this override request.
 * @property subnetId The subnet in which to launch the requested instance.
 * @property weightedCapacity The capacity added to the fleet by a fulfilled request.
 */
public data class SpotFleetRequestLaunchTemplateConfigOverride(
    public val availabilityZone: String? = null,
    public val instanceRequirements: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirements? =
        null,
    public val instanceType: String? = null,
    public val priority: Double? = null,
    public val spotPrice: String? = null,
    public val subnetId: String? = null,
    public val weightedCapacity: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotFleetRequestLaunchTemplateConfigOverride):
            SpotFleetRequestLaunchTemplateConfigOverride = SpotFleetRequestLaunchTemplateConfigOverride(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            instanceRequirements = javaType.instanceRequirements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirements.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            spotPrice = javaType.spotPrice().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
