@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName Name of the block device to mount on the instance.
 * @property noDevice Suppresses the specified device included in the AMI's block device mapping.
 * @property virtualName [Instance Store Device Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).
 * Each AWS Instance type has a different set of Instance Store block devices available for attachment. AWS [publishes a list](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes) of which ephemeral devices are available on each type. The devices are always identified by the `virtual_name` in the format `ephemeral{0..N}`.
 */
public data class SpotInstanceRequestEphemeralBlockDevice(
    public val deviceName: String,
    public val noDevice: Boolean? = null,
    public val virtualName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.SpotInstanceRequestEphemeralBlockDevice):
            SpotInstanceRequestEphemeralBlockDevice = SpotInstanceRequestEphemeralBlockDevice(
            deviceName = javaType.deviceName(),
            noDevice = javaType.noDevice().map({ args0 -> args0 }).orElse(null),
            virtualName = javaType.virtualName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
