@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the record subdomain the service provider needs to create.
 * @property state Verification state of the VPC endpoint service. Consumers of the endpoint service can use the private name only when the state is `verified`.
 * @property type Endpoint service verification type, for example `TXT`.
 * @property value Value the service provider adds to the private DNS name domain record before verification.
 */
public data class VpcEndpointServicePrivateDnsNameConfiguration(
    public val name: String? = null,
    public val state: String? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpcEndpointServicePrivateDnsNameConfiguration):
            VpcEndpointServicePrivateDnsNameConfiguration =
            VpcEndpointServicePrivateDnsNameConfiguration(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
