@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationCidrBlock The CIDR block associated with the local subnet of the customer data center.
 * @property source Indicates how the routes were provided.
 * @property state The current state of the static route.
 */
public data class VpnConnectionRoute(
    public val destinationCidrBlock: String? = null,
    public val source: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.VpnConnectionRoute): VpnConnectionRoute =
            VpnConnectionRoute(
                destinationCidrBlock = javaType.destinationCidrBlock().map({ args0 -> args0 }).orElse(null),
                source = javaType.source().map({ args0 -> args0 }).orElse(null),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
            )
    }
}
