@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.AuthorizationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides authorization rules for AWS Client VPN endpoints. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.AuthorizationRule;
 * import com.pulumi.aws.ec2clientvpn.AuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AuthorizationRule("example", AuthorizationRuleArgs.builder()
 *             .clientVpnEndpointId(aws_ec2_client_vpn_endpoint.example().id())
 *             .targetNetworkCidr(aws_subnet.example().cidr_block())
 *             .authorizeAllGroups(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using the endpoint ID, target network CIDR, and group name:
 * __Using `pulumi import` to import__ AWS Client VPN authorization rules using the endpoint ID and target network CIDR. If there is a specific group name, include that also. All values are separated by a `,`. For example:
 * Using the endpoint ID and target network CIDR:
 * ```sh
 *  $ pulumi import aws:ec2clientvpn/authorizationRule:AuthorizationRule example cvpn-endpoint-0ac3a1abbccddd666,10.1.0.0/24
 * ```
 *  Using the endpoint ID, target network CIDR, and group name:
 * ```sh
 *  $ pulumi import aws:ec2clientvpn/authorizationRule:AuthorizationRule example cvpn-endpoint-0ac3a1abbccddd666,10.1.0.0/24,team-a
 * ```
 * @property accessGroupId The ID of the group to which the authorization rule grants access. One of `access_group_id` or `authorize_all_groups` must be set.
 * @property authorizeAllGroups Indicates whether the authorization rule grants access to all clients. One of `access_group_id` or `authorize_all_groups` must be set.
 * @property clientVpnEndpointId The ID of the Client VPN endpoint.
 * @property description A brief description of the authorization rule.
 * @property targetNetworkCidr The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
 */
public data class AuthorizationRuleArgs(
    public val accessGroupId: Output<String>? = null,
    public val authorizeAllGroups: Output<Boolean>? = null,
    public val clientVpnEndpointId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val targetNetworkCidr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.AuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.AuthorizationRuleArgs =
        com.pulumi.aws.ec2clientvpn.AuthorizationRuleArgs.builder()
            .accessGroupId(accessGroupId?.applyValue({ args0 -> args0 }))
            .authorizeAllGroups(authorizeAllGroups?.applyValue({ args0 -> args0 }))
            .clientVpnEndpointId(clientVpnEndpointId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .targetNetworkCidr(targetNetworkCidr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationRuleArgs].
 */
@PulumiTagMarker
public class AuthorizationRuleArgsBuilder internal constructor() {
    private var accessGroupId: Output<String>? = null

    private var authorizeAllGroups: Output<Boolean>? = null

    private var clientVpnEndpointId: Output<String>? = null

    private var description: Output<String>? = null

    private var targetNetworkCidr: Output<String>? = null

    /**
     * @param value The ID of the group to which the authorization rule grants access. One of `access_group_id` or `authorize_all_groups` must be set.
     */
    @JvmName("kphmgbtpbjypaxqm")
    public suspend fun accessGroupId(`value`: Output<String>) {
        this.accessGroupId = value
    }

    /**
     * @param value Indicates whether the authorization rule grants access to all clients. One of `access_group_id` or `authorize_all_groups` must be set.
     */
    @JvmName("nxcthyakfstcnrxg")
    public suspend fun authorizeAllGroups(`value`: Output<Boolean>) {
        this.authorizeAllGroups = value
    }

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("nxswchyhvfmpvupj")
    public suspend fun clientVpnEndpointId(`value`: Output<String>) {
        this.clientVpnEndpointId = value
    }

    /**
     * @param value A brief description of the authorization rule.
     */
    @JvmName("orgbrrrfkqklpdxv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    @JvmName("oepbvkkgrrsxeqsa")
    public suspend fun targetNetworkCidr(`value`: Output<String>) {
        this.targetNetworkCidr = value
    }

    /**
     * @param value The ID of the group to which the authorization rule grants access. One of `access_group_id` or `authorize_all_groups` must be set.
     */
    @JvmName("csaiweieitudjmuy")
    public suspend fun accessGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupId = mapped
    }

    /**
     * @param value Indicates whether the authorization rule grants access to all clients. One of `access_group_id` or `authorize_all_groups` must be set.
     */
    @JvmName("psgcwqaenseadywp")
    public suspend fun authorizeAllGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizeAllGroups = mapped
    }

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("wnucxmmbxxlpundo")
    public suspend fun clientVpnEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientVpnEndpointId = mapped
    }

    /**
     * @param value A brief description of the authorization rule.
     */
    @JvmName("utknrakdqrppqqko")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    @JvmName("qarglfjnqffrgwnf")
    public suspend fun targetNetworkCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNetworkCidr = mapped
    }

    internal fun build(): AuthorizationRuleArgs = AuthorizationRuleArgs(
        accessGroupId = accessGroupId,
        authorizeAllGroups = authorizeAllGroups,
        clientVpnEndpointId = clientVpnEndpointId,
        description = description,
        targetNetworkCidr = targetNetworkCidr,
    )
}
