@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.Ec2clientvpnFunctions.getEndpointPlain
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.GetEndpointFilter
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.GetEndpointPlainArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.GetEndpointPlainArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointResult
import com.pulumi.aws.ec2clientvpn.kotlin.outputs.GetEndpointResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object Ec2clientvpnFunctions {
    /**
     * Get information on an EC2 Client VPN endpoint.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2clientvpn.Ec2clientvpnFunctions;
     * import com.pulumi.aws.ec2clientvpn.inputs.GetEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2clientvpnFunctions.getEndpoint(GetEndpointArgs.builder()
     *             .filters(GetEndpointFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("ExampleVpn")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2clientvpn.Ec2clientvpnFunctions;
     * import com.pulumi.aws.ec2clientvpn.inputs.GetEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2clientvpnFunctions.getEndpoint(GetEndpointArgs.builder()
     *             .clientVpnEndpointId("cvpn-endpoint-083cf50d6eb314f21")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEndpoint.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: GetEndpointPlainArgs): GetEndpointResult =
        toKotlin(getEndpointPlain(argument.toJava()).await())

    /**
     * @see [getEndpoint].
     * @param clientVpnEndpointId ID of the Client VPN endpoint.
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired endpoint.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(
        clientVpnEndpointId: String? = null,
        filters: List<GetEndpointFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetEndpointResult {
        val argument = GetEndpointPlainArgs(
            clientVpnEndpointId = clientVpnEndpointId,
            filters = filters,
            tags = tags,
        )
        return toKotlin(getEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2clientvpn&#46;kotlin&#46;inputs&#46;GetEndpointPlainArgs].
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: suspend GetEndpointPlainArgsBuilder.() -> Unit):
        GetEndpointResult {
        val builder = GetEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getEndpointPlain(builtArgument.toJava()).await())
    }
}
