@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.EndpointArgs.builder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointAuthenticationOptionArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointAuthenticationOptionArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientConnectOptionsArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientConnectOptionsArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientLoginBannerOptionsArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointClientLoginBannerOptionsArgsBuilder
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointConnectionLogOptionsArgs
import com.pulumi.aws.ec2clientvpn.kotlin.inputs.EndpointConnectionLogOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Client VPN endpoint for OpenVPN clients. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.Endpoint;
 * import com.pulumi.aws.ec2clientvpn.EndpointArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .description("clientvpn-example")
 *             .serverCertificateArn(aws_acm_certificate.cert().arn())
 *             .clientCidrBlock("10.0.0.0/16")
 *             .authenticationOptions(EndpointAuthenticationOptionArgs.builder()
 *                 .type("certificate-authentication")
 *                 .rootCertificateChainArn(aws_acm_certificate.root_cert().arn())
 *                 .build())
 *             .connectionLogOptions(EndpointConnectionLogOptionsArgs.builder()
 *                 .enabled(true)
 *                 .cloudwatchLogGroup(aws_cloudwatch_log_group.lg().name())
 *                 .cloudwatchLogStream(aws_cloudwatch_log_stream.ls().name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Client VPN endpoints using the `id` value found via `aws ec2 describe-client-vpn-endpoints`. For example:
 * ```sh
 *  $ pulumi import aws:ec2clientvpn/endpoint:Endpoint example cvpn-endpoint-0ac3a1abbccddd666
 * ```
 * @property authenticationOptions Information about the authentication method to be used to authenticate clients.
 * @property clientCidrBlock The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
 * @property clientConnectOptions The options for managing connection authorization for new client connections.
 * @property clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
 * @property connectionLogOptions Information about the client connection logging options.
 * @property description A brief description of the Client VPN endpoint.
 * @property dnsServers Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
 * @property securityGroupIds The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
 * @property selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
 * @property serverCertificateArn The ARN of the ACM server certificate.
 * @property sessionTimeoutHours The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
 * @property splitTunnel Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transportProtocol The transport protocol to be used by the VPN session. Default value is `udp`.
 * @property vpcId The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
 * @property vpnPort The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
 */
public data class EndpointArgs(
    public val authenticationOptions: Output<List<EndpointAuthenticationOptionArgs>>? = null,
    public val clientCidrBlock: Output<String>? = null,
    public val clientConnectOptions: Output<EndpointClientConnectOptionsArgs>? = null,
    public val clientLoginBannerOptions: Output<EndpointClientLoginBannerOptionsArgs>? = null,
    public val connectionLogOptions: Output<EndpointConnectionLogOptionsArgs>? = null,
    public val description: Output<String>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val selfServicePortal: Output<String>? = null,
    public val serverCertificateArn: Output<String>? = null,
    public val sessionTimeoutHours: Output<Int>? = null,
    public val splitTunnel: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transportProtocol: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpnPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.EndpointArgs =
        com.pulumi.aws.ec2clientvpn.EndpointArgs.builder()
            .authenticationOptions(
                authenticationOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clientCidrBlock(clientCidrBlock?.applyValue({ args0 -> args0 }))
            .clientConnectOptions(
                clientConnectOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clientLoginBannerOptions(
                clientLoginBannerOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectionLogOptions(
                connectionLogOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selfServicePortal(selfServicePortal?.applyValue({ args0 -> args0 }))
            .serverCertificateArn(serverCertificateArn?.applyValue({ args0 -> args0 }))
            .sessionTimeoutHours(sessionTimeoutHours?.applyValue({ args0 -> args0 }))
            .splitTunnel(splitTunnel?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transportProtocol(transportProtocol?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpnPort(vpnPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var authenticationOptions: Output<List<EndpointAuthenticationOptionArgs>>? = null

    private var clientCidrBlock: Output<String>? = null

    private var clientConnectOptions: Output<EndpointClientConnectOptionsArgs>? = null

    private var clientLoginBannerOptions: Output<EndpointClientLoginBannerOptionsArgs>? = null

    private var connectionLogOptions: Output<EndpointConnectionLogOptionsArgs>? = null

    private var description: Output<String>? = null

    private var dnsServers: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var selfServicePortal: Output<String>? = null

    private var serverCertificateArn: Output<String>? = null

    private var sessionTimeoutHours: Output<Int>? = null

    private var splitTunnel: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transportProtocol: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpnPort: Output<Int>? = null

    /**
     * @param value Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("mfaeqjcojfgnpshq")
    public suspend
    fun authenticationOptions(`value`: Output<List<EndpointAuthenticationOptionArgs>>) {
        this.authenticationOptions = value
    }

    @JvmName("qfdahebhronxfmia")
    public suspend fun authenticationOptions(
        vararg
        values: Output<EndpointAuthenticationOptionArgs>,
    ) {
        this.authenticationOptions = Output.all(values.asList())
    }

    /**
     * @param values Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("smopjhjhmsdauewd")
    public suspend fun authenticationOptions(values: List<Output<EndpointAuthenticationOptionArgs>>) {
        this.authenticationOptions = Output.all(values)
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @JvmName("ltmbenciqjmteuxp")
    public suspend fun clientCidrBlock(`value`: Output<String>) {
        this.clientCidrBlock = value
    }

    /**
     * @param value The options for managing connection authorization for new client connections.
     */
    @JvmName("krcrbwjfluvmpxxn")
    public suspend fun clientConnectOptions(`value`: Output<EndpointClientConnectOptionsArgs>) {
        this.clientConnectOptions = value
    }

    /**
     * @param value Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @JvmName("jbvpewgsraxskphw")
    public suspend
    fun clientLoginBannerOptions(`value`: Output<EndpointClientLoginBannerOptionsArgs>) {
        this.clientLoginBannerOptions = value
    }

    /**
     * @param value Information about the client connection logging options.
     */
    @JvmName("igcrcdxcoiyvfomm")
    public suspend fun connectionLogOptions(`value`: Output<EndpointConnectionLogOptionsArgs>) {
        this.connectionLogOptions = value
    }

    /**
     * @param value A brief description of the Client VPN endpoint.
     */
    @JvmName("qjqwghdsntxkqjfe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("mrjmbaaglabxsnpl")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("ibjacefkdcegsiyd")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("udnyxtbsewdlyvgi")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("qgeuxnpupchdcbxs")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("wumvdjtfejvhaduv")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("itnnonvxcsvheofe")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     */
    @JvmName("fupwglfxsqeaewyc")
    public suspend fun selfServicePortal(`value`: Output<String>) {
        this.selfServicePortal = value
    }

    /**
     * @param value The ARN of the ACM server certificate.
     */
    @JvmName("mupvledaawnofoed")
    public suspend fun serverCertificateArn(`value`: Output<String>) {
        this.serverCertificateArn = value
    }

    /**
     * @param value The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     */
    @JvmName("mdeoafgnwbouhuei")
    public suspend fun sessionTimeoutHours(`value`: Output<Int>) {
        this.sessionTimeoutHours = value
    }

    /**
     * @param value Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     */
    @JvmName("pugpqgxsentjptvj")
    public suspend fun splitTunnel(`value`: Output<Boolean>) {
        this.splitTunnel = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cgntjrfwlnmyimfc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The transport protocol to be used by the VPN session. Default value is `udp`.
     */
    @JvmName("crhkvhcdwxdlyxxj")
    public suspend fun transportProtocol(`value`: Output<String>) {
        this.transportProtocol = value
    }

    /**
     * @param value The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @JvmName("wepkoktrimirgltp")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     */
    @JvmName("fjvvjjdavvxytxkc")
    public suspend fun vpnPort(`value`: Output<Int>) {
        this.vpnPort = value
    }

    /**
     * @param value Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("choxqtjkpvxlvgwb")
    public suspend fun authenticationOptions(`value`: List<EndpointAuthenticationOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationOptions = mapped
    }

    /**
     * @param argument Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("aftaclhgvuuuxgcl")
    public suspend
    fun authenticationOptions(argument: List<suspend EndpointAuthenticationOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointAuthenticationOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationOptions = mapped
    }

    /**
     * @param argument Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("holypnmfyoxinjeq")
    public suspend fun authenticationOptions(
        vararg
        argument: suspend EndpointAuthenticationOptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointAuthenticationOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationOptions = mapped
    }

    /**
     * @param argument Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("hsyrixspabyylvow")
    public suspend
    fun authenticationOptions(argument: suspend EndpointAuthenticationOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointAuthenticationOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authenticationOptions = mapped
    }

    /**
     * @param values Information about the authentication method to be used to authenticate clients.
     */
    @JvmName("wnacyfndegahkmep")
    public suspend fun authenticationOptions(vararg values: EndpointAuthenticationOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationOptions = mapped
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @JvmName("sduwttqdximklscn")
    public suspend fun clientCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCidrBlock = mapped
    }

    /**
     * @param value The options for managing connection authorization for new client connections.
     */
    @JvmName("njrewkinhdxtomsq")
    public suspend fun clientConnectOptions(`value`: EndpointClientConnectOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientConnectOptions = mapped
    }

    /**
     * @param argument The options for managing connection authorization for new client connections.
     */
    @JvmName("rallddbmjqibokca")
    public suspend
    fun clientConnectOptions(argument: suspend EndpointClientConnectOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointClientConnectOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientConnectOptions = mapped
    }

    /**
     * @param value Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @JvmName("ompymmmdxhrjyhio")
    public suspend fun clientLoginBannerOptions(`value`: EndpointClientLoginBannerOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientLoginBannerOptions = mapped
    }

    /**
     * @param argument Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @JvmName("cuukvsqtpaoeenpj")
    public suspend
    fun clientLoginBannerOptions(argument: suspend EndpointClientLoginBannerOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointClientLoginBannerOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientLoginBannerOptions = mapped
    }

    /**
     * @param value Information about the client connection logging options.
     */
    @JvmName("cfgqaosfoiqsloxi")
    public suspend fun connectionLogOptions(`value`: EndpointConnectionLogOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionLogOptions = mapped
    }

    /**
     * @param argument Information about the client connection logging options.
     */
    @JvmName("htqirqvpmovjgcex")
    public suspend
    fun connectionLogOptions(argument: suspend EndpointConnectionLogOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointConnectionLogOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionLogOptions = mapped
    }

    /**
     * @param value A brief description of the Client VPN endpoint.
     */
    @JvmName("vbnreltandmfuemi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("phqkbwjlcxrjomfx")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     */
    @JvmName("kqpgwcaorrvumfge")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("whwxjvwqsllsnupv")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    @JvmName("xffovwojvcxtwbjb")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     */
    @JvmName("uektffccbwgpvbrr")
    public suspend fun selfServicePortal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfServicePortal = mapped
    }

    /**
     * @param value The ARN of the ACM server certificate.
     */
    @JvmName("yuuxpjfamudvxqma")
    public suspend fun serverCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateArn = mapped
    }

    /**
     * @param value The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     */
    @JvmName("dkvgrotmwvmshtga")
    public suspend fun sessionTimeoutHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeoutHours = mapped
    }

    /**
     * @param value Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     */
    @JvmName("yukcbqjxtqciysva")
    public suspend fun splitTunnel(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.splitTunnel = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lcfvpouhhdqpjlkv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("welxwetmfidrpqhh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The transport protocol to be used by the VPN session. Default value is `udp`.
     */
    @JvmName("tvukguxobloefywu")
    public suspend fun transportProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    /**
     * @param value The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @JvmName("plidfnafvolyctku")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     */
    @JvmName("ssqtvontqfpprxec")
    public suspend fun vpnPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnPort = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        authenticationOptions = authenticationOptions,
        clientCidrBlock = clientCidrBlock,
        clientConnectOptions = clientConnectOptions,
        clientLoginBannerOptions = clientLoginBannerOptions,
        connectionLogOptions = connectionLogOptions,
        description = description,
        dnsServers = dnsServers,
        securityGroupIds = securityGroupIds,
        selfServicePortal = selfServicePortal,
        serverCertificateArn = serverCertificateArn,
        sessionTimeoutHours = sessionTimeoutHours,
        splitTunnel = splitTunnel,
        tags = tags,
        transportProtocol = transportProtocol,
        vpcId = vpcId,
        vpnPort = vpnPort,
    )
}
