@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides network associations for AWS Client VPN endpoints. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociation;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NetworkAssociation("example", NetworkAssociationArgs.builder()
 *             .clientVpnEndpointId(aws_ec2_client_vpn_endpoint.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Client VPN network associations using the endpoint ID and the association ID. Values are separated by a `,`. For example:
 * ```sh
 *  $ pulumi import aws:ec2clientvpn/networkAssociation:NetworkAssociation example cvpn-endpoint-0ac3a1abbccddd666,vpn-assoc-0b8db902465d069ad
 * ```
 * @property clientVpnEndpointId The ID of the Client VPN endpoint.
 * @property subnetId The ID of the subnet to associate with the Client VPN endpoint.
 */
public data class NetworkAssociationArgs(
    public val clientVpnEndpointId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs =
        com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs.builder()
            .clientVpnEndpointId(clientVpnEndpointId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAssociationArgs].
 */
@PulumiTagMarker
public class NetworkAssociationArgsBuilder internal constructor() {
    private var clientVpnEndpointId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("cvljebtdeeyyrrvg")
    public suspend fun clientVpnEndpointId(`value`: Output<String>) {
        this.clientVpnEndpointId = value
    }

    /**
     * @param value The ID of the subnet to associate with the Client VPN endpoint.
     */
    @JvmName("vxhiytiujxfdapiu")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("rnutxowfsncrteaw")
    public suspend fun clientVpnEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientVpnEndpointId = mapped
    }

    /**
     * @param value The ID of the subnet to associate with the Client VPN endpoint.
     */
    @JvmName("fdftgdbqwcwqmoex")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): NetworkAssociationArgs = NetworkAssociationArgs(
        clientVpnEndpointId = clientVpnEndpointId,
        subnetId = subnetId,
    )
}
