@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin

import com.pulumi.aws.ec2clientvpn.RouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides additional routes for AWS Client VPN endpoints. For more information on usage, please see the
 * [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2clientvpn.Endpoint;
 * import com.pulumi.aws.ec2clientvpn.EndpointArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs;
 * import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociation;
 * import com.pulumi.aws.ec2clientvpn.NetworkAssociationArgs;
 * import com.pulumi.aws.ec2clientvpn.Route;
 * import com.pulumi.aws.ec2clientvpn.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEndpoint = new Endpoint("exampleEndpoint", EndpointArgs.builder()
 *             .description("Example Client VPN endpoint")
 *             .serverCertificateArn(aws_acm_certificate.example().arn())
 *             .clientCidrBlock("10.0.0.0/16")
 *             .authenticationOptions(EndpointAuthenticationOptionArgs.builder()
 *                 .type("certificate-authentication")
 *                 .rootCertificateChainArn(aws_acm_certificate.example().arn())
 *                 .build())
 *             .connectionLogOptions(EndpointConnectionLogOptionsArgs.builder()
 *                 .enabled(false)
 *                 .build())
 *             .build());
 *         var exampleNetworkAssociation = new NetworkAssociation("exampleNetworkAssociation", NetworkAssociationArgs.builder()
 *             .clientVpnEndpointId(exampleEndpoint.id())
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .clientVpnEndpointId(exampleEndpoint.id())
 *             .destinationCidrBlock("0.0.0.0/0")
 *             .targetVpcSubnetId(exampleNetworkAssociation.subnetId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Client VPN routes using the endpoint ID, target subnet ID, and destination CIDR block. All values are separated by a `,`. For example:
 * ```sh
 *  $ pulumi import aws:ec2clientvpn/route:Route example cvpn-endpoint-1234567890abcdef,subnet-9876543210fedcba,10.1.0.0/24
 * ```
 * @property clientVpnEndpointId The ID of the Client VPN endpoint.
 * @property description A brief description of the route.
 * @property destinationCidrBlock The IPv4 address range, in CIDR notation, of the route destination.
 * @property targetVpcSubnetId The ID of the Subnet to route the traffic through. It must already be attached to the Client VPN.
 */
public data class RouteArgs(
    public val clientVpnEndpointId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destinationCidrBlock: Output<String>? = null,
    public val targetVpcSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.RouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.RouteArgs =
        com.pulumi.aws.ec2clientvpn.RouteArgs.builder()
            .clientVpnEndpointId(clientVpnEndpointId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .targetVpcSubnetId(targetVpcSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var clientVpnEndpointId: Output<String>? = null

    private var description: Output<String>? = null

    private var destinationCidrBlock: Output<String>? = null

    private var targetVpcSubnetId: Output<String>? = null

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("njyqtfwqihvrxjha")
    public suspend fun clientVpnEndpointId(`value`: Output<String>) {
        this.clientVpnEndpointId = value
    }

    /**
     * @param value A brief description of the route.
     */
    @JvmName("hjequjplkmyoowjc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, of the route destination.
     */
    @JvmName("xxyeieikrmlxkwyg")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value The ID of the Subnet to route the traffic through. It must already be attached to the Client VPN.
     */
    @JvmName("xfsndhjfkmpjjnnl")
    public suspend fun targetVpcSubnetId(`value`: Output<String>) {
        this.targetVpcSubnetId = value
    }

    /**
     * @param value The ID of the Client VPN endpoint.
     */
    @JvmName("bphwgypjegfgkxae")
    public suspend fun clientVpnEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientVpnEndpointId = mapped
    }

    /**
     * @param value A brief description of the route.
     */
    @JvmName("ainbfgwpxfyeewms")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The IPv4 address range, in CIDR notation, of the route destination.
     */
    @JvmName("jgsxbaqlbmnoccjd")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value The ID of the Subnet to route the traffic through. It must already be attached to the Client VPN.
     */
    @JvmName("mgjokutlakvwgjni")
    public suspend fun targetVpcSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVpcSubnetId = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        clientVpnEndpointId = clientVpnEndpointId,
        description = description,
        destinationCidrBlock = destinationCidrBlock,
        targetVpcSubnetId = targetVpcSubnetId,
    )
}
