@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.inputs

import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property activeDirectoryId The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
 * @property rootCertificateChainArn The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
 * @property samlProviderArn The ARN of the IAM SAML identity provider if type is `federated-authentication`.
 * @property selfServiceSamlProviderArn The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
 * @property type The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
 */
public data class EndpointAuthenticationOptionArgs(
    public val activeDirectoryId: Output<String>? = null,
    public val rootCertificateChainArn: Output<String>? = null,
    public val samlProviderArn: Output<String>? = null,
    public val selfServiceSamlProviderArn: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs =
        com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs.builder()
            .activeDirectoryId(activeDirectoryId?.applyValue({ args0 -> args0 }))
            .rootCertificateChainArn(rootCertificateChainArn?.applyValue({ args0 -> args0 }))
            .samlProviderArn(samlProviderArn?.applyValue({ args0 -> args0 }))
            .selfServiceSamlProviderArn(selfServiceSamlProviderArn?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointAuthenticationOptionArgs].
 */
@PulumiTagMarker
public class EndpointAuthenticationOptionArgsBuilder internal constructor() {
    private var activeDirectoryId: Output<String>? = null

    private var rootCertificateChainArn: Output<String>? = null

    private var samlProviderArn: Output<String>? = null

    private var selfServiceSamlProviderArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
     */
    @JvmName("akrvhjdqdtfjhhtv")
    public suspend fun activeDirectoryId(`value`: Output<String>) {
        this.activeDirectoryId = value
    }

    /**
     * @param value The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
     */
    @JvmName("nbqsyxsdetyomwne")
    public suspend fun rootCertificateChainArn(`value`: Output<String>) {
        this.rootCertificateChainArn = value
    }

    /**
     * @param value The ARN of the IAM SAML identity provider if type is `federated-authentication`.
     */
    @JvmName("koamwmnlhnporeyr")
    public suspend fun samlProviderArn(`value`: Output<String>) {
        this.samlProviderArn = value
    }

    /**
     * @param value The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
     */
    @JvmName("rnxxlgwehsamtbew")
    public suspend fun selfServiceSamlProviderArn(`value`: Output<String>) {
        this.selfServiceSamlProviderArn = value
    }

    /**
     * @param value The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
     */
    @JvmName("nlfnayvrebhslvlw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
     */
    @JvmName("opntwqgbsaexbqyy")
    public suspend fun activeDirectoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryId = mapped
    }

    /**
     * @param value The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
     */
    @JvmName("weptgcddwanvjnlw")
    public suspend fun rootCertificateChainArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootCertificateChainArn = mapped
    }

    /**
     * @param value The ARN of the IAM SAML identity provider if type is `federated-authentication`.
     */
    @JvmName("tlatsphuxonmglnq")
    public suspend fun samlProviderArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlProviderArn = mapped
    }

    /**
     * @param value The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
     */
    @JvmName("yijpqvrhuxiutqqv")
    public suspend fun selfServiceSamlProviderArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfServiceSamlProviderArn = mapped
    }

    /**
     * @param value The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
     */
    @JvmName("bigsaehlspljnmiu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EndpointAuthenticationOptionArgs = EndpointAuthenticationOptionArgs(
        activeDirectoryId = activeDirectoryId,
        rootCertificateChainArn = rootCertificateChainArn,
        samlProviderArn = samlProviderArn,
        selfServiceSamlProviderArn = selfServiceSamlProviderArn,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
