@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.inputs

import com.pulumi.aws.ec2clientvpn.inputs.EndpointClientConnectOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Indicates whether client connect options are enabled. The default is `false` (not enabled).
 * @property lambdaFunctionArn The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
 */
public data class EndpointClientConnectOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val lambdaFunctionArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.inputs.EndpointClientConnectOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.inputs.EndpointClientConnectOptionsArgs =
        com.pulumi.aws.ec2clientvpn.inputs.EndpointClientConnectOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .lambdaFunctionArn(lambdaFunctionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointClientConnectOptionsArgs].
 */
@PulumiTagMarker
public class EndpointClientConnectOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var lambdaFunctionArn: Output<String>? = null

    /**
     * @param value Indicates whether client connect options are enabled. The default is `false` (not enabled).
     */
    @JvmName("kwdursuwpvtvorti")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
     */
    @JvmName("xjlefyxxdlatdpmg")
    public suspend fun lambdaFunctionArn(`value`: Output<String>) {
        this.lambdaFunctionArn = value
    }

    /**
     * @param value Indicates whether client connect options are enabled. The default is `false` (not enabled).
     */
    @JvmName("owtahpdktugoqauh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
     */
    @JvmName("rvjahtmvgsxdkjdm")
    public suspend fun lambdaFunctionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionArn = mapped
    }

    internal fun build(): EndpointClientConnectOptionsArgs = EndpointClientConnectOptionsArgs(
        enabled = enabled,
        lambdaFunctionArn = lambdaFunctionArn,
    )
}
