@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.inputs

import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogGroup The name of the CloudWatch Logs log group.
 * @property cloudwatchLogStream The name of the CloudWatch Logs log stream to which the connection data is published.
 * @property enabled Indicates whether connection logging is enabled.
 */
public data class EndpointConnectionLogOptionsArgs(
    public val cloudwatchLogGroup: Output<String>? = null,
    public val cloudwatchLogStream: Output<String>? = null,
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs =
        com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs.builder()
            .cloudwatchLogGroup(cloudwatchLogGroup?.applyValue({ args0 -> args0 }))
            .cloudwatchLogStream(cloudwatchLogStream?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConnectionLogOptionsArgs].
 */
@PulumiTagMarker
public class EndpointConnectionLogOptionsArgsBuilder internal constructor() {
    private var cloudwatchLogGroup: Output<String>? = null

    private var cloudwatchLogStream: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The name of the CloudWatch Logs log group.
     */
    @JvmName("oocfjisitaamniyc")
    public suspend fun cloudwatchLogGroup(`value`: Output<String>) {
        this.cloudwatchLogGroup = value
    }

    /**
     * @param value The name of the CloudWatch Logs log stream to which the connection data is published.
     */
    @JvmName("ovclfshvytmkiefb")
    public suspend fun cloudwatchLogStream(`value`: Output<String>) {
        this.cloudwatchLogStream = value
    }

    /**
     * @param value Indicates whether connection logging is enabled.
     */
    @JvmName("fdpfthnrybhjhyxp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the CloudWatch Logs log group.
     */
    @JvmName("rouuibncvvllemnq")
    public suspend fun cloudwatchLogGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogGroup = mapped
    }

    /**
     * @param value The name of the CloudWatch Logs log stream to which the connection data is published.
     */
    @JvmName("aradjgxnrapjqrra")
    public suspend fun cloudwatchLogStream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogStream = mapped
    }

    /**
     * @param value Indicates whether connection logging is enabled.
     */
    @JvmName("plbqnohlxjpqkeis")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): EndpointConnectionLogOptionsArgs = EndpointConnectionLogOptionsArgs(
        cloudwatchLogGroup = cloudwatchLogGroup,
        cloudwatchLogStream = cloudwatchLogStream,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
