@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property activeDirectoryId The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
 * @property rootCertificateChainArn The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
 * @property samlProviderArn The ARN of the IAM SAML identity provider if type is `federated-authentication`.
 * @property selfServiceSamlProviderArn The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
 * @property type The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
 */
public data class EndpointAuthenticationOption(
    public val activeDirectoryId: String? = null,
    public val rootCertificateChainArn: String? = null,
    public val samlProviderArn: String? = null,
    public val selfServiceSamlProviderArn: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2clientvpn.outputs.EndpointAuthenticationOption):
            EndpointAuthenticationOption = EndpointAuthenticationOption(
            activeDirectoryId = javaType.activeDirectoryId().map({ args0 -> args0 }).orElse(null),
            rootCertificateChainArn = javaType.rootCertificateChainArn().map({ args0 -> args0 }).orElse(null),
            samlProviderArn = javaType.samlProviderArn().map({ args0 -> args0 }).orElse(null),
            selfServiceSamlProviderArn = javaType.selfServiceSamlProviderArn().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
