@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2clientvpn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bannerText Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
 * @property enabled Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
 */
public data class EndpointClientLoginBannerOptions(
    public val bannerText: String? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2clientvpn.outputs.EndpointClientLoginBannerOptions):
            EndpointClientLoginBannerOptions = EndpointClientLoginBannerOptions(
            bannerText = javaType.bannerText().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
