@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Connect].
 */
@PulumiTagMarker
public class ConnectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectArgs = ConnectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectArgsBuilder.() -> Unit) {
        val builder = ConnectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Connect {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.Connect(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connect(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Connect.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import com.pulumi.aws.ec2transitgateway.Connect;
 * import com.pulumi.aws.ec2transitgateway.ConnectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetIds(aws_subnet.example().id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *         var attachment = new Connect("attachment", ConnectArgs.builder()
 *             .transportAttachmentId(example.id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_connect` using the EC2 Transit Gateway Connect identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/connect:Connect example tgw-attach-12345678
 * ```
 *
 */
public class Connect internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.Connect,
) : KotlinCustomResource(javaResource, ConnectMapper) {
    /**
     * The tunnel protocol. Valid values: `gre`. Default is `gre`.
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value tags for the EC2 Transit Gateway Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean whether the Connect should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    public val transitGatewayDefaultRouteTableAssociation: Output<Boolean>?
        get() = javaResource.transitGatewayDefaultRouteTableAssociation().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Boolean whether the Connect should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    public val transitGatewayDefaultRouteTablePropagation: Output<Boolean>?
        get() = javaResource.transitGatewayDefaultRouteTablePropagation().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Identifier of EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })

    /**
     * The underlaying VPC attachment
     */
    public val transportAttachmentId: Output<String>
        get() = javaResource.transportAttachmentId().applyValue({ args0 -> args0 })
}

public object ConnectMapper : ResourceMapper<Connect> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.Connect::class == javaResource::class

    override fun map(javaResource: Resource): Connect = Connect(
        javaResource as
            com.pulumi.aws.ec2transitgateway.Connect,
    )
}

/**
 * @see [Connect].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connect].
 */
public suspend fun connect(name: String, block: suspend ConnectResourceBuilder.() -> Unit):
    Connect {
    val builder = ConnectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connect].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connect(name: String): Connect {
    val builder = ConnectResourceBuilder()
    builder.name(name)
    return builder.build()
}
